/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.remote.io.server;

import java.rmi.Remote;
import java.io.*;

/**
 * Server interface to the remote input stream.
 *
 * @see edu.emory.mathcs.util.remote.io.RemoteInputStream
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface RemoteInputStreamSrv extends Remote {
    byte[] read(int maxRead) throws IOException;
    long skip(long n) throws IOException;
    int available() throws IOException;
    void close() throws IOException;
}
